<?php
/**
 * Cron job script for executing the BuyerCheck process_orders function.
 *
 * You can set this up as a cron job on your server to run periodically from your hosting or cron service on the server.
 *
 **/

 // Set cron job from ubuntu terminal to run every 8 hours, by running this to open the crontab file:
 # sudo crontab -e
 
 // Add one of the following lines to the crontab file (without leading #):
 
 // 1. Standard Apache/Nginx (run as web server user):
 # 0 * * * * sudo -u www-data /usr/bin/php /absolute_path_to_opencart_root/catalog/controller/extension/fraud/cron_buyercheck.php
 
 // 2. Bitnami (run as daemon user):
 # 0 * * * * sudo -u daemon /opt/bitnami/php/bin/php /opt/bitnami/opencart3/catalog/controller/extension/fraud/cron_buyercheck.php
  
 // 3. cPanel (run as cpanel user):
 # 0 * * * * sudo -u cpanel /usr/bin/php /home/username/public_html/catalog/controller/extension/fraud/cron_buyercheck.php
 
 /**
  * 
  * Make sure to replace /absolute_path_to_opencart_root/ with the actual absolute path to your store's root directory.
  * You may also need to adjust the path to your PHP executable (/usr/bin/php).
  * You need to run the command as your web server user for the cron job to work "sudo -u www-data" or "sudo -u daemon" or "sudo -u cpanel".
  *
  **/

// Security check: Only allow CLI execution
if (php_sapi_name() !== 'cli') {
    die('Forbidden');
}

// Get the directory of this script and navigate to OpenCart root
$script_dir = dirname(__FILE__);
$opencart_root = dirname(dirname(dirname(dirname($script_dir))));

// Validate OpenCart installation exists
$opencart_root = realpath($opencart_root);
if (!$opencart_root || !is_dir($opencart_root) || !file_exists($opencart_root . '/index.php')) {
    die('Error: OpenCart installation not found.');
}

// Store original directory for potential restoration
$original_dir = getcwd();

// Change to OpenCart root directory
chdir($opencart_root);

// Set up server environment BEFORE any output
$_SERVER['SERVER_PROTOCOL'] = 'HTTP/1.1';
$_SERVER['REQUEST_METHOD'] = 'GET';
$_SERVER['HTTP_HOST'] = 'localhost';
$_SERVER['REQUEST_URI'] = '/index.php?route=extension/fraud/buyercheck/process_orders';
$_SERVER['SCRIPT_NAME'] = '/index.php';
$_SERVER['QUERY_STRING'] = 'route=extension/fraud/buyercheck/process_orders';
$_SERVER['SERVER_NAME'] = 'localhost';
$_SERVER['SERVER_PORT'] = '80';
$_SERVER['REMOTE_ADDR'] = '127.0.0.1';
//$_SERVER['HTTPS'] = 'on'; // Uncomment if your store uses SSL

// Set additional environment variables that OpenCart might need
putenv('DOCUMENT_ROOT=' . $opencart_root);
putenv('SCRIPT_FILENAME=' . $opencart_root . '/index.php');

// Set the route
$_GET['route'] = 'extension/fraud/buyercheck/process_orders';

// Start output buffering BEFORE loading OpenCart
ob_start();

try {
    // Load OpenCart - this will bootstrap the entire framework
    require_once('index.php');
    
    // Capture any output from OpenCart
    $output = ob_get_clean();
    if (!empty($output)) {
        echo "OpenCart Output:\n" . $output . "\n";
    }
    
    echo "OpenCart execution completed successfully.\n";
    
} catch (Exception $e) {
    ob_end_clean();
    // Log detailed error for debugging (not output to console)
    error_log("BuyerCheck Cron Exception: " . $e->getMessage() . "\n" . $e->getTraceAsString());
    echo "Error during OpenCart execution. Check error logs for details.\n";
    exit(1);
} catch (Error $e) {
    ob_end_clean();
    // Log detailed error for debugging (not output to console)
    error_log("BuyerCheck Cron Fatal Error: " . $e->getMessage() . "\n" . $e->getTraceAsString());
    echo "Fatal error during OpenCart execution. Check error logs for details.\n";
    exit(1);
}

echo "BuyerCheck Cron Job Completed at " . date('Y-m-d H:i:s') . "\n";

exit();

?>